/*
 * Decompiled with CFR 0.152.
 */
package up4dar_configurator;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UP4DAR_SNMP {
    DatagramSocket socket;
    InetAddress addr;
    static final int BER_INTEGER = 2;
    static final int BER_OCTETSTRING = 4;
    static final int BER_NULL = 5;
    static final int BER_OID = 6;
    static final int BER_SEQUENCE = 48;
    static final int BER_SNMP_GET = 160;
    static final int BER_SNMP_GETNEXT = 161;
    static final int BER_SNMP_RESPONSE = 162;
    static final int BER_SNMP_SET = 163;
    static int request_id = 0;
    static final byte[] up4dar_oid = new byte[]{43, 6, 1, 3, -85, 69, 1};
    public static final int snmpDefaultTimeout = 800;
    boolean timeOutOccured = true;
    static final String defaultCommunityString = "public";

    UP4DAR_SNMP(InetAddress addr) {
        this.addr = addr;
        this.socket = null;
    }

    static char getOIDChar(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + i - 10);
    }

    int get_oid_len(String oid) {
        return up4dar_oid.length + oid.length();
    }

    void oid_copy(byte[] binData, byte[] oidBytes, int pointer, String oid) {
        int i;
        for (i = 0; i < up4dar_oid.length; ++i) {
            binData[pointer + i] = up4dar_oid[i];
            oidBytes[i] = up4dar_oid[i];
        }
        for (i = 0; i < oid.length(); ++i) {
            char c = oid.charAt(i);
            byte d = c >= '0' && c <= '9' ? (byte)(c & 0xF) : (byte)((c & 0x1F) + 9);
            binData[pointer + i + UP4DAR_SNMP.up4dar_oid.length] = d;
            oidBytes[i + UP4DAR_SNMP.up4dar_oid.length] = d;
        }
    }

    public String snmpConnect() throws Exception {
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(800);
        }
        catch (SocketException ex) {
            Logger.getLogger(UP4DAR_SNMP.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return this.snmpGetString("110");
    }

    SNMP_Response parseReply(SNMP_Request req, DatagramPacket dp) {
        SNMP_Parser p = new SNMP_Parser(dp);
        if (p.check_type(48) != 0) {
            return null;
        }
        p.enter_sequence();
        if (p.get_integer() != 0) {
            return null;
        }
        if (p.value != 0) {
            return null;
        }
        p.ber_skip();
        p.result_bytes = new byte[100];
        if (p.get_octetstring(4, p.result_bytes.length) != 0) {
            return null;
        }
        p.ber_skip();
        if (p.check_type(162) != 0) {
            return null;
        }
        p.enter_sequence();
        if (p.get_integer() != 0) {
            return null;
        }
        if (p.value != req.reqId) {
            return null;
        }
        p.ber_skip();
        if (p.check_type(2) != 0) {
            return null;
        }
        if (p.get_integer() != 0) {
            return null;
        }
        if (p.value != 0) {
            return null;
        }
        p.ber_skip();
        if (p.check_type(2) != 0) {
            return null;
        }
        p.ber_skip();
        if (p.check_type(48) != 0) {
            return null;
        }
        p.enter_sequence();
        if (p.check_type(48) != 0) {
            return null;
        }
        p.enter_sequence();
        p.result_bytes = new byte[req.oidBytes.length];
        if (p.get_octetstring(6, req.oidBytes.length) != 0) {
            return null;
        }
        if (p.result_len != req.oidBytes.length) {
            return null;
        }
        for (int i = 0; i < req.oidBytes.length; ++i) {
            if (p.result_bytes[i] == req.oidBytes[i]) continue;
            return null;
        }
        p.ber_skip();
        if (req.reqType == SNMP_ReqType.SetRequest) {
            return new SNMP_Response();
        }
        if (req.dataType == SNMP_DataType.Integer) {
            if (p.check_type(2) != 0) {
                return null;
            }
            if (p.get_integer() != 0) {
                return null;
            }
            return new SNMP_Response(p.value);
        }
        if (p.check_type(4) != 0) {
            return null;
        }
        int len = p.get_length();
        if (len < 0) {
            return null;
        }
        p.result_bytes = new byte[len];
        if (p.get_octetstring(4, len) != 0) {
            return null;
        }
        return new SNMP_Response(p.result_bytes);
    }

    SNMP_Response sendAndRecv(SNMP_Request req) {
        DatagramPacket dp = new DatagramPacket(req.binData, req.udpPacketLen, this.addr, 161);
        byte[] recvBuf = new byte[200];
        DatagramPacket drx = new DatagramPacket(recvBuf, recvBuf.length);
        if (this.timeOutOccured) {
            try {
                this.socket.setSoTimeout(5);
            }
            catch (IOException ex) {
                Logger.getLogger(UP4DAR_SNMP.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            boolean done = false;
            while (!done) {
                try {
                    this.socket.receive(drx);
                }
                catch (SocketTimeoutException ex) {
                    done = true;
                }
                catch (IOException ex) {
                    Logger.getLogger(UP4DAR_SNMP.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
            try {
                this.socket.setSoTimeout(800);
            }
            catch (IOException ex) {
                Logger.getLogger(UP4DAR_SNMP.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            this.timeOutOccured = false;
        }
        for (int retryCounter = 3; retryCounter > 0; --retryCounter) {
            try {
                this.socket.send(dp);
            }
            catch (IOException ex) {
                Logger.getLogger(UP4DAR_SNMP.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            try {
                this.socket.receive(drx);
                return this.parseReply(req, drx);
            }
            catch (SocketTimeoutException ex) {
                this.timeOutOccured = true;
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(UP4DAR_SNMP.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        return null;
    }

    public byte[] snmpGetBinaryString(String oid) throws Exception {
        SNMP_Request req = new SNMP_Request(SNMP_DataType.OctetString, SNMP_ReqType.GetRequest, oid, defaultCommunityString, null);
        SNMP_Response res = this.sendAndRecv(req);
        if (res != null && res.getDataType() == SNMP_DataType.OctetString) {
            return res.getData();
        }
        throw new Exception("getString failed, oid=" + oid);
    }

    public String snmpGetString(String oid) throws Exception {
        return new String(this.snmpGetBinaryString(oid));
    }

    void snmpSetBinaryString(String oid, byte[] dataBytes) throws Exception {
        SNMP_Request req = new SNMP_Request(SNMP_DataType.OctetString, SNMP_ReqType.SetRequest, oid, defaultCommunityString, dataBytes);
        SNMP_Response res = this.sendAndRecv(req);
        if (res == null) {
            throw new Exception("setString failed, oid=" + oid);
        }
    }

    void snmpSetString(String oid, String data) throws Exception {
        this.snmpSetBinaryString(oid, data.getBytes());
    }

    public int snmpGetInteger(String oid) throws Exception {
        SNMP_Request req = new SNMP_Request(SNMP_DataType.Integer, SNMP_ReqType.GetRequest, oid, defaultCommunityString, null);
        SNMP_Response res = this.sendAndRecv(req);
        if (res != null && res.getDataType() == SNMP_DataType.Integer) {
            return res.getIntValue();
        }
        throw new Exception("getInteger failed, oid=" + oid);
    }

    void snmpSetInteger(String oid, int value) throws Exception {
        byte[] dataBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dataBytes[i] = (byte)(value >> 8 * (3 - i) & 0xFF);
        }
        SNMP_Request req = new SNMP_Request(SNMP_DataType.Integer, SNMP_ReqType.SetRequest, oid, defaultCommunityString, dataBytes);
        SNMP_Response res = this.sendAndRecv(req);
        if (res == null) {
            throw new Exception("setInteger failed, oid=" + oid + " value=" + value);
        }
    }

    class SNMP_Parser {
        byte[] data;
        int pointer;
        int data_remaining;
        int len_len;
        int value;
        int result_len;
        byte[] result_bytes;

        SNMP_Parser(DatagramPacket dp) {
            this.data = new byte[dp.getLength()];
            for (int i = 0; i < dp.getLength(); ++i) {
                this.data[i] = dp.getData()[i];
            }
            this.pointer = 0;
            this.data_remaining = this.data.length;
        }

        int getOctet(int ptr) {
            byte b = this.data[ptr + this.pointer];
            if (b < 0) {
                return 256 + b;
            }
            return b;
        }

        int get_length() {
            int len = this.getOctet(1);
            this.len_len = 1;
            if (len > 127) {
                switch (this.getOctet(1) & 0x7F) {
                    case 1: {
                        len = this.getOctet(2);
                        this.len_len = 2;
                        break;
                    }
                    case 2: {
                        len = this.getOctet(2) << 8 | this.getOctet(3);
                        this.len_len = 3;
                        break;
                    }
                    default: {
                        len = -1;
                    }
                }
            }
            return len;
        }

        int check_type(int datatype) {
            if (datatype != this.getOctet(0)) {
                return 1;
            }
            int len = this.get_length();
            if (len < 0) {
                return 1;
            }
            if (len + 1 + this.len_len > this.data_remaining) {
                return 1;
            }
            return 0;
        }

        int get_integer() {
            if (2 != this.getOctet(0)) {
                return 1;
            }
            int len = this.get_length();
            if (len < 0) {
                return 1;
            }
            if (len + 1 + this.len_len > this.data_remaining) {
                return 1;
            }
            this.value = 0;
            if ((this.getOctet(1 + this.len_len) & 0x80) != 0) {
                this.value = -1;
            }
            for (int i = 0; i < len; ++i) {
                this.value = this.value << 8 | this.getOctet(1 + i + this.len_len);
            }
            return 0;
        }

        int get_octetstring(int valType, int maxlen) {
            if (this.getOctet(0) != valType) {
                return 1;
            }
            int len = this.get_length();
            if (len < 0) {
                return 1;
            }
            if (len + 1 + this.len_len > this.data_remaining) {
                return 1;
            }
            if (len > maxlen) {
                return 1;
            }
            for (int i = 0; i < len; ++i) {
                this.result_bytes[i] = this.data[this.pointer + i + this.len_len + 1];
            }
            this.result_len = len;
            return 0;
        }

        void enter_sequence() {
            int len = this.get_length();
            if (len < 0) {
                return;
            }
            this.pointer += 1 + this.len_len;
            this.data_remaining -= 1 + this.len_len;
        }

        void ber_skip() {
            int len = this.get_length();
            if (len < 0) {
                return;
            }
            this.pointer += 1 + this.len_len + len;
            this.data_remaining -= 1 + this.len_len + len;
        }
    }

    class SNMP_Response {
        private SNMP_DataType datatype;
        int value;
        byte[] octetstring;

        public SNMP_Response() {
            this.datatype = SNMP_DataType.Integer;
            this.value = 0;
        }

        public SNMP_Response(int value) {
            this.datatype = SNMP_DataType.Integer;
            this.value = value;
        }

        public SNMP_Response(byte[] octetstring) {
            this.datatype = SNMP_DataType.OctetString;
            this.octetstring = octetstring;
        }

        private SNMP_DataType getDataType() {
            return this.datatype;
        }

        int getIntValue() {
            return this.value;
        }

        byte[] getData() {
            return this.octetstring;
        }
    }

    class SNMP_Request {
        final int reqId = ++request_id;
        final SNMP_DataType dataType;
        final SNMP_ReqType reqType;
        final int udpPacketLen;
        byte[] binData;
        byte[] oidBytes;

        public SNMP_Request(SNMP_DataType dataType, SNMP_ReqType reqType, String oid, String communityString, byte[] setData) {
            int t;
            int i;
            this.reqType = reqType;
            this.dataType = dataType;
            this.binData = new byte[600];
            this.oidBytes = new byte[UP4DAR_SNMP.this.get_oid_len(oid)];
            byte[] cmnty = communityString.getBytes();
            int community_string_len = cmnty.length;
            if (community_string_len >= 127) {
                community_string_len = 126;
            }
            int tmp_len = 0;
            tmp_len += UP4DAR_SNMP.this.get_oid_len(oid);
            if (reqType == SNMP_ReqType.SetRequest) {
                tmp_len += setData.length;
                tmp_len += 4;
            } else {
                tmp_len += 2;
            }
            tmp_len += 2;
            tmp_len += 4;
            tmp_len += 4;
            tmp_len += 3;
            tmp_len += 3;
            tmp_len += 6;
            tmp_len += 4;
            tmp_len += 2 + community_string_len;
            this.udpPacketLen = (tmp_len += 3) + 4;
            if (this.udpPacketLen > this.binData.length) {
                // empty if block
            }
            int p = 0;
            this.binData[p + 0] = 48;
            this.binData[p + 1] = -126;
            this.binData[p + 2] = (byte)(tmp_len >> 8 & 0xFF);
            this.binData[p + 3] = (byte)(tmp_len & 0xFF);
            this.binData[(p += 4) + 0] = 2;
            this.binData[p + 1] = 1;
            this.binData[p + 2] = 0;
            this.binData[(p += 3) + 0] = 4;
            this.binData[p + 1] = (byte)community_string_len;
            for (i = 0; i < community_string_len; ++i) {
                this.binData[p + 2 + i] = cmnty[i];
            }
            this.binData[(p += 2 + community_string_len) + 0] = reqType == SNMP_ReqType.SetRequest ? -93 : -96;
            this.binData[p + 1] = -126;
            this.binData[p + 2] = (byte)((tmp_len -= 5 + community_string_len + 4) >> 8 & 0xFF);
            this.binData[p + 3] = (byte)(tmp_len & 0xFF);
            this.binData[(p += 4) + 0] = 2;
            this.binData[p + 1] = 4;
            this.binData[p + 2] = (byte)(this.reqId >> 24 & 0xFF);
            this.binData[p + 3] = (byte)(this.reqId >> 16 & 0xFF);
            this.binData[p + 4] = (byte)(this.reqId >> 8 & 0xFF);
            this.binData[p + 5] = (byte)(this.reqId & 0xFF);
            this.binData[(p += 6) + 0] = 2;
            this.binData[p + 1] = 1;
            this.binData[p + 2] = 0;
            this.binData[(p += 3) + 0] = 2;
            this.binData[p + 1] = 1;
            this.binData[p + 2] = 0;
            this.binData[(p += 3) + 0] = 48;
            this.binData[p + 1] = -126;
            this.binData[p + 2] = (byte)((tmp_len -= 16) >> 8 & 0xFF);
            this.binData[p + 3] = (byte)(tmp_len & 0xFF);
            p += 4;
            int oid_len = UP4DAR_SNMP.this.get_oid_len(oid);
            if (reqType == SNMP_ReqType.SetRequest) {
                t = setData.length;
                t += 4;
            } else {
                t = 2;
            }
            t += oid_len;
            this.binData[p + 0] = 48;
            this.binData[p + 1] = -126;
            this.binData[p + 2] = (byte)((t += 2) >> 8 & 0xFF);
            this.binData[p + 3] = (byte)(t & 0xFF);
            this.binData[(p += 4) + 0] = 6;
            this.binData[p + 1] = (byte)oid_len;
            UP4DAR_SNMP.this.oid_copy(this.binData, this.oidBytes, p + 2, oid);
            p += 2 + oid_len;
            if (reqType == SNMP_ReqType.SetRequest) {
                this.binData[p + 0] = dataType == SNMP_DataType.Integer ? 2 : 4;
                this.binData[p + 1] = -126;
                this.binData[p + 2] = (byte)(setData.length >> 8 & 0xFF);
                this.binData[p + 3] = (byte)(setData.length & 0xFF);
                for (i = 0; i < setData.length; ++i) {
                    this.binData[p + 4 + i] = setData[i];
                }
            } else {
                this.binData[p + 0] = 5;
                this.binData[p + 1] = 0;
            }
        }
    }

    static enum SNMP_ReqType {
        GetRequest,
        SetRequest;

    }

    static enum SNMP_DataType {
        OctetString,
        Integer;

    }
}

